/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: EcatDPM_Functionlist.h $

    $GlobalRev: 63951 $
    $Version: V2.5.42.0 $
    $Packaged: 2016-09-12 15:21 $

   Targets:
    rcX          : yes

   Description:

    Ecat DPM
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
       5       23.03.2007   sb
         Updated source header
         Corrected Task entry function

       4       21.03.2007   sb
         Code cleanup

**************************************************************************************/
/**
 * @file EcatDPM_Functionlist.h
 * @brief Ecat DPM - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_EcatDPM</code>
 * of task.
 */
#ifndef __ECAT_DPM_FUNCTIONLIST_H
#define __ECAT_DPM_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * @{
 */

void
TaskEnter_EcatDPM
(
  void* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define ECAT_DPM_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct ECAT_DPM_STARTUPPARAMETER_Ttag  ECAT_DPM_STARTUPPARAMETER_T;

/*=============================================================================*/
typedef struct ECS_ADDRESS_SWITCH_INIT_HEADER_Ttag* ECS_ADDRESS_SWITCH_HANDLE;

typedef struct ECS_ADDRESS_SWITCH_INIT_HEADER_Ttag
{
  TLR_RESULT (* pfnAddressSwitchInit)(
      const struct ECS_ADDRESS_SWITCH_INIT_HEADER_Ttag* ptAddrSwitchInitData,
      ECS_ADDRESS_SWITCH_HANDLE* phAddrSwitchHandle);
  /* next two are initialized within pptAddrSwitchHandle only { */
  void (* pfnAddressSwitchDeinit)(
      ECS_ADDRESS_SWITCH_HANDLE hAddrSwitchHandle);
  TLR_UINT32 (* pfnAddressSwitchGet)(
      ECS_ADDRESS_SWITCH_HANDLE hAddrSwitchHandle);
  /* } */
} ECS_ADDRESS_SWITCH_INIT_HEADER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct ECAT_DPM_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;

  TLR_BOOLEAN32               fNoDisableBusUpdateTriggerOnHostUpdateEnabled;
  TLR_BOOLEAN32               fSII_EoE_Details_Enable;
  TLR_BOOLEAN32               fSII_FoE_Details_Enable;
  TLR_UINT16                  usMailboxSize;        /* 0 == default 128, < 128 is extended to 128 */
  TLR_UINT16                  usSm2StartAddr;       /* 0 == default value, otherwise 0x1000 + 2* mailbox size minimum (additionally, must be dword aligned on netX100/500) */
  TLR_UINT16                  usSm3StartAddr;       /* only used if usSm2StartAddr is unequal 0 */
  TLR_UINT16                  usStackVariant;       /* 0 = CoE, 1 = SoE */
  TLR_BOOLEAN32               fSII_EoE_Init_Enable;
  const ECS_ADDRESS_SWITCH_INIT_HEADER_T* ptAddressSwitchInit;
};

/** @} */

/*=============================================================================*/

#ifdef __ROTARYSWITCH_INCLUDES_H
#include <malloc.h>

typedef struct ECS_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_Ttag
{
  ECS_ADDRESS_SWITCH_INIT_HEADER_T tHead;

  ROTARYSWITCH_INIT_FKT_T pfnInitAddressSwitch;
  ROTARYSWITCH_CONFIG_PARAMETER_T* ptAddressSwitchParam;
  /* internal will be used internally { */
  ROTARYSWITCH_GET_FKT_T pfnGetAddressSwitch;
  ROTARYSWITCH_DEINIT_FKT_T pfnDeinitAddressSwitch;
  void* pvFuncParam;
  /* } */
} ECS_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T;

static
void
Ecs_Deinit_AddressSwitch_From_RotarySwitch(
    ECS_ADDRESS_SWITCH_HANDLE hAddrSwitchHandle)
{
  ECS_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T* ptRotarySwitchHandle = (ECS_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T*) hAddrSwitchHandle;
  ptRotarySwitchHandle->pfnDeinitAddressSwitch(ptRotarySwitchHandle->pvFuncParam);
  free(ptRotarySwitchHandle);
}

static
uint32_t
Ecs_Get_AddressSwitch_From_RotarySwitch(
    ECS_ADDRESS_SWITCH_HANDLE hAddrSwitchHandle)
{
  ECS_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T* ptRotarySwitchHandle = (ECS_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T*) hAddrSwitchHandle;
  return ptRotarySwitchHandle->pfnGetAddressSwitch(ptRotarySwitchHandle->pvFuncParam);
}

static
TLR_RESULT
Ecs_Init_AddressSwitch_From_RotarySwitch(
    const ECS_ADDRESS_SWITCH_INIT_HEADER_T* ptAddressSwitchInit,
    ECS_ADDRESS_SWITCH_HANDLE* phAddrSwitchHandle)
{
  TLR_RESULT tResult;
  ECS_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T* ptRotarySwitchParams = (ECS_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T*)ptAddressSwitchInit;
  ECS_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T* ptRotarySwitchHandle;

  ptRotarySwitchHandle = malloc(sizeof(*ptRotarySwitchHandle));
  if(NULL == ptRotarySwitchHandle)
  {
    tResult = TLR_E_OUTOFMEMORY;
  }
  else
  {
    *ptRotarySwitchHandle = *ptRotarySwitchParams;
    ptRotarySwitchHandle->tHead.pfnAddressSwitchDeinit = Ecs_Deinit_AddressSwitch_From_RotarySwitch;
    ptRotarySwitchHandle->tHead.pfnAddressSwitchGet = Ecs_Get_AddressSwitch_From_RotarySwitch;
    tResult = ptRotarySwitchHandle->pfnInitAddressSwitch(
        &ptRotarySwitchHandle->pfnGetAddressSwitch,
        &ptRotarySwitchHandle->pfnDeinitAddressSwitch,
        ptRotarySwitchHandle->ptAddressSwitchParam,
        &ptRotarySwitchHandle->pvFuncParam);
    if(TLR_S_OK != tResult)
    {
      free(ptRotarySwitchHandle);
      ptRotarySwitchHandle = NULL;
    }
  }
  *phAddrSwitchHandle = &ptRotarySwitchHandle->tHead;
  return tResult;
}

#define DEFINE_ECS_ROTARY_SWITCH_AS_ADDRESS_SWITCH(tName, pfnInitAddressSwitch, ptAddressSwitchParam) \
    const ECS_ADDRESS_SWITCH_INIT_ROTARY_SWITCH_T tName = \
    { \
      { \
        Ecs_Init_AddressSwitch_From_RotarySwitch \
      }, \
      pfnInitAddressSwitch, \
      ptAddressSwitchParam \
    }

#define USE_ECS_ROTARY_SWITCH_AS_ADDRESS_SWITCH(tName) \
    (tName.tHead)

#endif


/*************************************************************************************/
#endif /* #ifndef __ECAT_DPM_FUNCTIONLIST_H */
